function [Cext,Csca,Cabs] = cross_sections(pos, alphae, alphah, alphaeh,...
    EHsol, EH0, k0, epsout)

% Function for the calculation of the cross sections once the solution to
% the coupling equation is done.

%%%%%% INPUT ARGUMENTS %%%%%%
%%% pos:     position of the dipoles                                 %%%
%%% alphae:  electric polarizabilities of the dipoles                %%%
%%% alphah:  magnetic polarizabilities of the dipoles                %%%
%%% alphaeh: mixed magnetic electric polarizabilities of the dipoles %%%
%%% EHsol:   total exciting electromagnetic field at each dipole     %%%
%%% EH0:     exciting electromagnetic wave (6D vectorial function)   %%%
%%% k0:      wavenumber                                              %%%
%%% espout:  surrounding permittivity                                %%%



%%%%%% OUTPUT ARGUMENTS %%%%%%
%%% Cext: extinction cross section (k0^(-2) units) %%%
%%% Csca: scattering cross section (k0^(-2) units) %%%
%%% Cabs: absorption cross section (k0^(-2) units) %%%


% Constants %
load('vacPer.mat','eps0','mu0');
eps0 = epsout*eps0;
Z0   = sqrt(mu0/eps0);


% Data for loops %
N    = length(pos(:,1));
K  = length(k0);
Cext  = zeros(1,K);
Cabs  = Cext;

% If L = 2, the polarizability is wavelength indepndent and the same for
% all dipole. If K>1 and L = 3 the polarizability is only a function of
% the wavelength and if L = 4 it also depends on the position (dipole).
% If K = 1 and L = 3 it only depndends on the position and if L = 2 the
% polarizability is wavelength independent and the same for all dipoles.
S = size(alphae);
L = length(S);

if(K > 1)
    if(L > 3)
        parfor i = 1:K

            EHinc = squeeze(EHsol(i,:,:));
            
            for j = 1:N

                ae  = squeeze(alphae(i,j,:,:));
                ah  = squeeze(alphah(i,j,:,:));
                aeh = squeeze(alphaeh(i,j,:,:));
                p = ae*EHinc(j,1:3).' - 1i*mu0*aeh*(EHinc(j,4:6)).';
                m = ah*EHinc(j,4:6).' + 1i*aeh*(EHinc(j,1:3)).';
                
                r = pos(j,:);
                EHinc0 = EH0(Z0,k0(i),r);
                Einc   = EHinc0(1:3);
                Hinc   = EHinc0(4:6);

                Cext(i) = Cext(i) + (k0(i)/eps0/norm(Einc)^2)*...
                    imag(dot(Einc,p) + mu0*dot(Hinc,m));
                
                Cabs(i) = Cabs(i)  + (k0(i)/eps0/norm(Einc)^2)*...
                    (imag(dot(EHinc(j,1:3).',p) + ...
                    mu0*dot(EHinc(j,4:6).',m)) - ...
                    k0(i)^3/(6*pi)*(dot(p,p)/eps0+mu0*dot(m,m)));

            end

        end
    else
        parfor i = 1:K
        
            EHinc = squeeze(EHsol(i,:,:));
            ae    = squeeze(alphae(i,:,:));
            ah    = squeeze(alphah(i,:,:));
            aeh   = squeeze(alphaeh(i,:,:));

            for j = 1:N
                
                p = ae*EHinc(j,1:3).' - 1i*mu0*aeh*(EHinc(j,4:6)).';
                m = ah*EHinc(j,4:6).' + 1i*aeh*(EHinc(j,1:3)).';
                
                r = pos(j,:);
                EHinc0 = EH0(Z0,k0(i),r);
                Einc   = EHinc0(1:3);
                Hinc   = EHinc0(4:6);

                Cext(i) = Cext(i) + (k0(i)/eps0/norm(Einc)^2)*...
                    imag(dot(Einc,p) + mu0*dot(Hinc,m));
                
                Cabs(i) = Cabs(i)  + (k0(i)/eps0/norm(Einc)^2)*...
                    (imag(dot(EHinc(j,1:3).',p) + ...
                    mu0*dot(EHinc(j,4:6).',m)) - ...
                    k0(i)^3/(6*pi)*(dot(p,p)/eps0+mu0*dot(m,m)));

            end
            
        end
    end
   
else
    
    EHinc = squeeze(EHsol);

    if( L > 2)
        
        for j = 1:N

            ae  = squeeze(alphae(j,:,:));
            ah  = squeeze(alphah(j,:,:));
            aeh = squeeze(alphaeh(j,:,:));
            p = ae*EHinc(j,1:3).' - 1i*mu0*aeh*(EHinc(j,4:6)).';
            m = ah*EHinc(j,4:6).' + 1i*aeh*(EHinc(j,1:3)).';

            

            r = pos(j,:);
            EHinc0 = EH0(Z0,k0,r);
            Einc   = EHinc0(1:3);
            Hinc   = EHinc0(4:6);

            Cext = Cext + (k0/eps0/norm(Einc)^2)*...
                imag(dot(Einc,p) + mu0*dot(Hinc,m));

            Cabs = Cabs + (k0/eps0/norm(Einc)^2)*...
                (imag(dot(EHinc(j,1:3).',p) + ...
                mu0*dot(EHinc(j,4:6).',m)) - ...
                k0^3/(6*pi)*(dot(p,p)/eps0+mu0*dot(m,m)));

        end

    else
    
        for j = 1:N

            p = alphae*EHinc(j,1:3).' - 1i*mu0*alphaeh*(EHinc(j,4:6)).';
            m = alphah*EHinc(j,4:6).' + 1i*alphaeh*(EHinc(j,1:3)).';

            r = pos(j,:);
            EHinc0 = EH0(Z0,k0,r);
            Einc   = EHinc0(1:3);
            Hinc   = EHinc0(4:6);

            Cext = Cext + (k0/eps0/norm(Einc)^2)*...
                imag(dot(Einc,p) + mu0*dot(Hinc,m));

            Cabs = Cabs + (k0/eps0/norm(Einc)^2)*...
                (imag(dot(EHinc(j,1:3).',p) + ...
                mu0*dot(EHinc(j,4:6).',m)) - ...
                k0^3/(6*pi)*(dot(p,p)/eps0+mu0*dot(m,m)));

        end

    end


end

Csca = Cext-Cabs;

end

